/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.repository.ConsultationRepository;
import org.hopeclinic.gestiondespatients.service.FactureService;
import org.hopeclinic.gestiondespatients.type.EtatFacture;
import org.hopeclinic.gestiondespatients.type.EtatOperation;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ConsultationService {
    private final ConsultationRepository consultationRepository;
    private final FactureService factureService;

    public ConsultationService(ConsultationRepository consultationRepository, FactureService factureService) {
        this.consultationRepository = consultationRepository;
        this.factureService = factureService;
    }

    public List<Consultation> getConsultationsByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.consultationRepository);
    }

    public List<Consultation> getAllConsultations() {
        return this.consultationRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public long getTodayEnAttenteConsultationCount() {
        Date today = new Date();
        return this.consultationRepository.countByEtatAndDateCreation(EtatOperation.EN_ATTENTE, today);
    }

    public long countConsultationsByEtat(EtatOperation etat) {
        return this.consultationRepository.countByEtat(etat);
    }

    public long getTodayConsultationCount() {
        Date today = new Date();
        return this.consultationRepository.countByDateCreation(today);
    }

    public Long count() {
        return this.consultationRepository.count();
    }

    public Consultation getConsultationById(Long id) {
        Optional consultationOptional = this.consultationRepository.findById(id);
        return consultationOptional.orElse(null);
    }

    public Consultation createConsultation(Consultation consultation) {
        Consultation savedConsultation = (Consultation)this.consultationRepository.save(consultation);
        Facture facture = new Facture(null, UUID.randomUUID().toString(), consultation.getPrix(), false, 0, 0.0, 0.0, 0.0, EtatFacture.NON_PAYEE, null, null, savedConsultation, null, consultation.getBonExamen(), null, null, null, savedConsultation.getDossierMedical().getPatient());
        this.factureService.createFacture(facture);
        return savedConsultation;
    }

    public Consultation updateConsultation(Long id, Consultation updatedConsultation) {
        Optional consultationOptional = this.consultationRepository.findById(id);
        if (consultationOptional.isPresent()) {
            Consultation consultation = (Consultation)consultationOptional.get();
            consultation.setEtat(updatedConsultation.getEtat());
            consultation.setLieu(updatedConsultation.getLieu());
            consultation.setDiagnostic(updatedConsultation.getDiagnostic());
            consultation.setMotif(updatedConsultation.getMotif());
            consultation.setPartPayeeParPatient(updatedConsultation.getPartPayeeParPatient());
            if (updatedConsultation.getSymptomes() != null) {
                consultation.setSymptomes(updatedConsultation.getSymptomes());
            }
            return (Consultation)this.consultationRepository.save(consultation);
        }
        return null;
    }

    public boolean deleteConsultation(Long id) {
        Optional consultationOptional = this.consultationRepository.findById(id);
        if (consultationOptional.isPresent()) {
            this.consultationRepository.delete((Consultation)consultationOptional.get());
            return true;
        }
        return false;
    }
}

