/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hopeclinic.gestiondespatients.error.NotFoundException;
import org.hopeclinic.gestiondespatients.model.Antecedent;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Ordonnance;
import org.hopeclinic.gestiondespatients.model.Soin;
import org.hopeclinic.gestiondespatients.repository.DossierMedicalRepository;
import org.hopeclinic.gestiondespatients.type.EtatOperation;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class DossierMedicalService {
    private final DossierMedicalRepository dossierMedicalRepository;

    public DossierMedicalService(DossierMedicalRepository dossierMedicalRepository) {
        this.dossierMedicalRepository = dossierMedicalRepository;
    }

    public List<DossierMedical> getAllDossierMedicals() {
        return this.dossierMedicalRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<DossierMedical> getDossierMedicalByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.dossierMedicalRepository);
    }

    public Long count() {
        return this.dossierMedicalRepository.count();
    }

    public DossierMedical getDossierMedicalById(Long id) {
        Optional dossierMedicalOptional = this.dossierMedicalRepository.findById(id);
        return dossierMedicalOptional.orElse(null);
    }

    public DossierMedical createDossierMedical(DossierMedical dossierMedical) {
        return (DossierMedical)this.dossierMedicalRepository.save(dossierMedical);
    }

    public DossierMedical updateDossierMedical(Long id, DossierMedical updatedDossierMedical) {
        Optional dossierMedicalOptional = this.dossierMedicalRepository.findById(id);
        if (dossierMedicalOptional.isPresent()) {
            DossierMedical dossierMedical = (DossierMedical)dossierMedicalOptional.get();
            dossierMedical.setElectrophorese(updatedDossierMedical.getElectrophorese());
            dossierMedical.setGroupeSanguin(updatedDossierMedical.getGroupeSanguin());
            dossierMedical.setAntecedents(updatedDossierMedical.getAntecedents());
            return (DossierMedical)this.dossierMedicalRepository.save(dossierMedical);
        }
        return null;
    }

    public boolean deleteDossierMedical(Long id) {
        Optional dossierMedicalOptional = this.dossierMedicalRepository.findById(id);
        if (dossierMedicalOptional.isPresent()) {
            this.dossierMedicalRepository.delete((DossierMedical)dossierMedicalOptional.get());
            return true;
        }
        return false;
    }

    public List<Consultation> getConsultationsByDossierMedical(Long dossierMedicalId) {
        DossierMedical dossierMedical = (DossierMedical)this.dossierMedicalRepository.findById(dossierMedicalId).orElseThrow(() -> new NotFoundException("Dossier Medical introuvable"));
        return dossierMedical.getConsultations().stream().filter(consultation -> consultation.getEtat().equals((Object)EtatOperation.TERMINEE)).limit(10L).collect(Collectors.toList());
    }

    public List<Ordonnance> getOrdonnancesByDossierMedical(Long dossierMedicalId) {
        DossierMedical dossierMedical = (DossierMedical)this.dossierMedicalRepository.findById(dossierMedicalId).orElseThrow(() -> new NotFoundException("Dossier Medical introuvable"));
        List ordonnances = dossierMedical.getConsultations().stream().map(consultation -> consultation.getOrdonnance()).collect(Collectors.toList());
        return ordonnances.stream().limit(10L).collect(Collectors.toList());
    }

    public List<BonExamen> getBonExamensByDossierMedical(Long dossierMedicalId) {
        DossierMedical dossierMedical = (DossierMedical)this.dossierMedicalRepository.findById(dossierMedicalId).orElseThrow(() -> new NotFoundException("Dossier Medical introuvable"));
        return dossierMedical.getBonsExamens().stream().limit(10L).collect(Collectors.toList());
    }

    public List<Antecedent> getAntecedentsByDossierMedical(Long dossierMedicalId) {
        DossierMedical dossierMedical = (DossierMedical)this.dossierMedicalRepository.findById(dossierMedicalId).orElseThrow(() -> new NotFoundException("Dossier Medical introuvable"));
        return dossierMedical.getAntecedents().stream().limit(10L).collect(Collectors.toList());
    }

    public List<Soin> getSoinsByDossierMedical(Long dossierMedicalId) {
        DossierMedical dossierMedical = (DossierMedical)this.dossierMedicalRepository.findById(dossierMedicalId).orElseThrow(() -> new NotFoundException("Dossier Medical introuvable"));
        return dossierMedical.getSoins().stream().limit(10L).collect(Collectors.toList());
    }
}

