/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Acte;
import org.hopeclinic.gestiondespatients.model.Examen;
import org.hopeclinic.gestiondespatients.repository.ExamenRepository;
import org.hopeclinic.gestiondespatients.service.ActeService;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ExamenService {
    private final ExamenRepository examenRepository;
    private final ActeService acteService;

    public ExamenService(ExamenRepository examenRepository, ActeService acteService) {
        this.examenRepository = examenRepository;
        this.acteService = acteService;
    }

    public List<Examen> getAllExamens() {
        return this.examenRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Examen> getExamensByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.examenRepository);
    }

    public Long count() {
        return this.examenRepository.count();
    }

    public Examen getExamenById(Long id) {
        Optional examenOptional = this.examenRepository.findById(id);
        return examenOptional.orElse(null);
    }

    public Examen createExamen(Examen examen) {
        Acte acte = new Acte(null, examen.getNom(), examen.getDateCreation(), null, examen.getBonExamen().getConsultation().getPersonnelMedical(), null, examen.getBonExamen().getService());
        this.acteService.createActe(acte);
        return (Examen)this.examenRepository.save(examen);
    }

    public Examen updateExamen(Long id, Examen updatedExamen) {
        Optional examenOptional = this.examenRepository.findById(id);
        if (examenOptional.isPresent()) {
            Examen examen = (Examen)examenOptional.get();
            examen.setNom(updatedExamen.getNom());
            examen.setPriseEnChargeStructure(updatedExamen.getPriseEnChargeStructure());
            return (Examen)this.examenRepository.save(examen);
        }
        return null;
    }

    public boolean deleteExamen(Long id) {
        Optional examenOptional = this.examenRepository.findById(id);
        if (examenOptional.isPresent()) {
            this.examenRepository.delete((Examen)examenOptional.get());
            return true;
        }
        return false;
    }
}

