/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Recu;
import org.hopeclinic.gestiondespatients.repository.FactureRepository;
import org.hopeclinic.gestiondespatients.service.RecuService;
import org.hopeclinic.gestiondespatients.type.EtatFacture;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class FactureService {
    private final FactureRepository factureRepository;
    private final RecuService recuService;

    public FactureService(FactureRepository factureRepository, RecuService recuService) {
        this.factureRepository = factureRepository;
        this.recuService = recuService;
    }

    public List<Facture> getAllFactures() {
        return this.factureRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Facture> getFacturesByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.factureRepository);
    }

    public Long count() {
        return this.factureRepository.count();
    }

    public long countFacturesByEtat(EtatFacture etat) {
        return this.factureRepository.countByEtat(etat);
    }

    public Facture getFactureById(Long id) {
        Optional factureOptional = this.factureRepository.findById(id);
        return factureOptional.orElse(null);
    }

    public Consultation getConsultationByFactureId(Long id) {
        Optional factureOptional = this.factureRepository.findById(id);
        Consultation consultation = null;
        if (factureOptional.isPresent()) {
            Facture facture = (Facture)factureOptional.get();
            consultation = facture.getConsultation();
        }
        return consultation;
    }

    public BonExamen getBonExamenByFactureId(Long id) {
        Optional factureOptional = this.factureRepository.findById(id);
        BonExamen bonExamen = null;
        if (factureOptional.isPresent()) {
            Facture facture = (Facture)factureOptional.get();
            bonExamen = facture.getBonExamen();
        }
        return bonExamen;
    }

    public Facture createFacture(Facture facture) {
        return (Facture)this.factureRepository.save(facture);
    }

    public Facture updateFacture(Long id, Facture updatedFacture) {
        Optional factureOptional = this.factureRepository.findById(id);
        if (factureOptional.isPresent()) {
            Facture facture = (Facture)factureOptional.get();
            facture.setEtat(updatedFacture.getEtat());
            facture.setMontantTotal(updatedFacture.getMontantTotal());
            facture.setResteAPayer(updatedFacture.getResteAPayer());
            facture.setReductionAppliquee(updatedFacture.getReductionAppliquee());
            facture.setPourcentageReduction(updatedFacture.getPourcentageReduction());
            facture.setPartPayeePatient(updatedFacture.getPartPayeePatient());
            facture.setPartPayeeAssurance(updatedFacture.getPartPayeeAssurance());
            facture.setAssurance(updatedFacture.getAssurance());
            if (facture.getRecu() == null) {
                Recu recu = new Recu(null, facture.getMontantTotal(), "Consultation en " + facture.getConsultation().getService().getNom(), facture.getConsultation().getLieu(), new Date(), null, null, facture, facture.getPatient());
                Recu savedRecu = this.recuService.createRecu(recu);
                facture.setRecu(savedRecu);
            }
            return (Facture)this.factureRepository.save(facture);
        }
        return null;
    }

    public boolean deleteFacture(Long id) {
        Optional factureOptional = this.factureRepository.findById(id);
        if (factureOptional.isPresent()) {
            this.factureRepository.delete((Facture)factureOptional.get());
            return true;
        }
        return false;
    }
}

