/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Hospitalisation;
import org.hopeclinic.gestiondespatients.repository.HospitalisationRepository;
import org.hopeclinic.gestiondespatients.service.FactureService;
import org.hopeclinic.gestiondespatients.type.EtatFacture;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class HospitalisationService {
    private final HospitalisationRepository hospitalisationRepository;
    private final FactureService factureService;

    public HospitalisationService(HospitalisationRepository hospitalisationRepository, FactureService factureService) {
        this.hospitalisationRepository = hospitalisationRepository;
        this.factureService = factureService;
    }

    public List<Hospitalisation> getAllHospitalisations() {
        return this.hospitalisationRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Hospitalisation> getHospitalisationsByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.hospitalisationRepository);
    }

    public Long count() {
        return this.hospitalisationRepository.count();
    }

    public Hospitalisation getHospitalisationById(Long id) {
        Optional hospitalisationOptional = this.hospitalisationRepository.findById(id);
        return hospitalisationOptional.orElse(null);
    }

    public Hospitalisation createHospitalisation(Hospitalisation hospitalisation) {
        Hospitalisation savedHospitalisation = (Hospitalisation)this.hospitalisationRepository.save(hospitalisation);
        Facture facture = new Facture(null, UUID.randomUUID().toString(), hospitalisation.getPrixChambre(), false, 0, 0.0, 0.0, 0.0, EtatFacture.NON_PAYEE, null, null, null, savedHospitalisation, null, null, null, null, savedHospitalisation.getPatient());
        this.factureService.createFacture(facture);
        return savedHospitalisation;
    }

    public Hospitalisation updateHospitalisation(Long id, Hospitalisation updatedHospitalisation) {
        Optional hospitalisationOptional = this.hospitalisationRepository.findById(id);
        if (hospitalisationOptional.isPresent()) {
            Hospitalisation hospitalisation = (Hospitalisation)hospitalisationOptional.get();
            hospitalisation.setObservation(updatedHospitalisation.getObservation());
            hospitalisation.setNbJour(updatedHospitalisation.getNbJour());
            hospitalisation.setNbPassageMedecin(updatedHospitalisation.getNbPassageMedecin());
            hospitalisation.setDateEntree(updatedHospitalisation.getDateEntree());
            hospitalisation.setDateSortie(updatedHospitalisation.getDateSortie());
            hospitalisation.setNbPassageMedecinSpecialiste(updatedHospitalisation.getNbPassageMedecinSpecialiste());
            hospitalisation.setPrixChambre(updatedHospitalisation.getPrixChambre());
            hospitalisation.setPartPayee(updatedHospitalisation.getPartPayee());
            return (Hospitalisation)this.hospitalisationRepository.save(hospitalisation);
        }
        return null;
    }

    public boolean deleteHospitalisation(Long id) {
        Optional hospitalisationOptional = this.hospitalisationRepository.findById(id);
        if (hospitalisationOptional.isPresent()) {
            this.hospitalisationRepository.delete((Hospitalisation)hospitalisationOptional.get());
            return true;
        }
        return false;
    }
}

