/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Ordonnance;
import org.hopeclinic.gestiondespatients.repository.OrdonnanceRepository;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class OrdonnanceService {
    private final OrdonnanceRepository ordonnanceRepository;

    public OrdonnanceService(OrdonnanceRepository ordonnanceRepository) {
        this.ordonnanceRepository = ordonnanceRepository;
    }

    public List<Ordonnance> getAllOrdonnances() {
        return this.ordonnanceRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Ordonnance> getOrdonnancesByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.ordonnanceRepository);
    }

    public Long count() {
        return this.ordonnanceRepository.count();
    }

    public Ordonnance getOrdonnanceById(Long id) {
        Optional ordonnanceOptional = this.ordonnanceRepository.findById(id);
        return ordonnanceOptional.orElse(null);
    }

    public Ordonnance createOrdonnance(Ordonnance ordonnance) {
        return (Ordonnance)this.ordonnanceRepository.save(ordonnance);
    }

    public Ordonnance updateOrdonnance(Long id, Ordonnance updatedOrdonnance) {
        Optional ordonnanceOptional = this.ordonnanceRepository.findById(id);
        if (ordonnanceOptional.isPresent()) {
            Ordonnance ordonnance = (Ordonnance)ordonnanceOptional.get();
            ordonnance.setPrescriptions(updatedOrdonnance.getPrescriptions());
            return (Ordonnance)this.ordonnanceRepository.save(ordonnance);
        }
        return null;
    }

    public boolean deleteOrdonnance(Long id) {
        Optional ordonnanceOptional = this.ordonnanceRepository.findById(id);
        if (ordonnanceOptional.isPresent()) {
            this.ordonnanceRepository.delete((Ordonnance)ordonnanceOptional.get());
            return true;
        }
        return false;
    }
}

