/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.error.NotFoundException;
import org.hopeclinic.gestiondespatients.model.Antecedent;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.model.Soin;
import org.hopeclinic.gestiondespatients.repository.PatientRepository;
import org.hopeclinic.gestiondespatients.service.DossierMedicalService;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class PatientService {
    private final PatientRepository patientRepository;
    private final DossierMedicalService dossierMedicalService;

    public PatientService(PatientRepository patientRepository, DossierMedicalService dossierMedicalService) {
        this.patientRepository = patientRepository;
        this.dossierMedicalService = dossierMedicalService;
    }

    public List<Patient> getAllPatients() {
        return this.patientRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Patient> getPatientsByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.patientRepository);
    }

    public Long count() {
        return this.patientRepository.count();
    }

    public Patient getPatientById(Long id) {
        Optional patientOptional = this.patientRepository.findById(id);
        return patientOptional.orElse(null);
    }

    public Patient createPatient(Patient patient) {
        Patient savedPatient = (Patient)this.patientRepository.save(patient);
        DossierMedical dossierMedical = new DossierMedical(null, null, null, null, null, savedPatient, null, null, null, null, null);
        this.dossierMedicalService.createDossierMedical(dossierMedical);
        return savedPatient;
    }

    public Patient updatePatient(Long id, Patient updatedPatient) {
        Optional patientOptional = this.patientRepository.findById(id);
        if (patientOptional.isPresent()) {
            Patient patient = (Patient)patientOptional.get();
            patient.setNom(updatedPatient.getNom());
            patient.setPrenom(updatedPatient.getPrenom());
            patient.setAdresse(updatedPatient.getAdresse());
            patient.setFonction(updatedPatient.getFonction());
            patient.setDateDeNaissance(updatedPatient.getDateDeNaissance());
            patient.setContact(updatedPatient.getContact());
            patient.setEmail(updatedPatient.getEmail());
            patient.setSexe(updatedPatient.getSexe());
            patient.setUsername(updatedPatient.getUsername());
            patient.setPersonneAContacter(updatedPatient.getPersonneAContacter());
            patient.setLienParente(updatedPatient.getLienParente());
            patient.setFonctionPersonne(updatedPatient.getFonctionPersonne());
            patient.setContactPersonne(updatedPatient.getContactPersonne());
            patient.setAdressePersonne(updatedPatient.getAdressePersonne());
            return (Patient)this.patientRepository.save(patient);
        }
        return null;
    }

    public boolean deletePatient(Long id) {
        Optional patientOptional = this.patientRepository.findById(id);
        if (patientOptional.isPresent()) {
            this.patientRepository.delete((Patient)patientOptional.get());
            return true;
        }
        return false;
    }

    public DossierMedical getDossierMedicalByPatient(Long patientId) {
        Patient patient = (Patient)this.patientRepository.findById(patientId).orElseThrow(() -> new NotFoundException("Patient introuvable"));
        List<Consultation> consultations = patient.getDossierMedical().getConsultations();
        List<BonExamen> bonsExamens = patient.getDossierMedical().getBonsExamens();
        List<Soin> soins = patient.getDossierMedical().getSoins();
        List<Antecedent> antecedents = patient.getDossierMedical().getAntecedents();
        patient.getDossierMedical().setConsultations(Utils.getLastNItems(consultations, 10));
        patient.getDossierMedical().setBonsExamens(Utils.getLastNItems(bonsExamens, 10));
        patient.getDossierMedical().setSoins(Utils.getLastNItems(soins, 10));
        patient.getDossierMedical().setAntecedents(Utils.getLastNItems(antecedents, 30));
        return patient.getDossierMedical();
    }

    public Map<String, Long> getPatientStatsBySexe() {
        List<Object[]> stats = this.patientRepository.countBySexe();
        HashMap<String, Long> patientStats = new HashMap<String, Long>();
        for (Object[] stat : stats) {
            String sexe = (String)stat[0];
            Long count = (Long)stat[1];
            patientStats.put(sexe, count);
        }
        return patientStats;
    }
}

