/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import org.hopeclinic.gestiondespatients.error.NotFoundException;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Hospitalisation;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Rdv;
import org.hopeclinic.gestiondespatients.model.Role;
import org.hopeclinic.gestiondespatients.repository.PersonnelMedicalRepository;
import org.hopeclinic.gestiondespatients.repository.RoleRepository;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.hopeclinic.gestiondespatients.validator.PersonnelMedicalValidator;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class PersonnelMedicalService {
    private final PersonnelMedicalRepository personnelMedicalRepository;
    private final PersonnelMedicalValidator personnelMedicalValidator;
    private final RoleRepository roleRepository;

    public PersonnelMedicalService(PersonnelMedicalRepository personnelMedicalRepository, PersonnelMedicalValidator personnelMedicalValidator, RoleRepository roleRepository) {
        this.personnelMedicalRepository = personnelMedicalRepository;
        this.personnelMedicalValidator = personnelMedicalValidator;
        this.roleRepository = roleRepository;
    }

    public List<PersonnelMedical> getAllPersonnelsMedicaux() {
        return this.personnelMedicalRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public Long count() {
        return this.personnelMedicalRepository.count();
    }

    public Long countByPersonnelRole(Long roleId) {
        Optional roleOptional = this.roleRepository.findById(roleId);
        if (roleOptional.isPresent()) {
            Role role = (Role)roleOptional.get();
            return this.personnelMedicalRepository.countPersonnelMedicalByRole(role);
        }
        return null;
    }

    public PersonnelMedical getPersonnelMedicalById(Long id) {
        Optional personnelMedicalOptional = this.personnelMedicalRepository.findById(id);
        return personnelMedicalOptional.orElse(null);
    }

    public PersonnelMedical createPersonnelMedical(PersonnelMedical personnelMedical) {
        return (PersonnelMedical)this.personnelMedicalRepository.save(personnelMedical);
    }

    public PersonnelMedical updatePersonnelMedical(Long id, PersonnelMedical updatedPersonnelMedical) {
        Optional personnelMedicalOptional = this.personnelMedicalRepository.findById(id);
        if (personnelMedicalOptional.isPresent()) {
            PersonnelMedical personnelMedical = (PersonnelMedical)personnelMedicalOptional.get();
            personnelMedical.setNom(updatedPersonnelMedical.getNom());
            personnelMedical.setPrenom(updatedPersonnelMedical.getPrenom());
            personnelMedical.setMotDePasse(updatedPersonnelMedical.getMotDePasse());
            personnelMedical.setEmail(updatedPersonnelMedical.getEmail());
            personnelMedical.setAdresse(updatedPersonnelMedical.getAdresse());
            personnelMedical.setContact(updatedPersonnelMedical.getContact());
            personnelMedical.setDateDeNaissance(updatedPersonnelMedical.getDateDeNaissance());
            personnelMedical.setUsername(updatedPersonnelMedical.getUsername());
            personnelMedical.setSexe(updatedPersonnelMedical.getSexe());
            personnelMedical.setService(updatedPersonnelMedical.getService());
            personnelMedical.setRole(updatedPersonnelMedical.getRole());
            return (PersonnelMedical)this.personnelMedicalRepository.save(personnelMedical);
        }
        return null;
    }

    public boolean deletePersonnelMedical(Long id) {
        Optional personnelMedicalOptional = this.personnelMedicalRepository.findById(id);
        if (personnelMedicalOptional.isPresent()) {
            this.personnelMedicalRepository.delete((PersonnelMedical)personnelMedicalOptional.get());
            return true;
        }
        return false;
    }

    public List<Consultation> getConsultationsByPersonnelMedical(Long personnelMedicalId) {
        PersonnelMedical personnelMedical = (PersonnelMedical)this.personnelMedicalRepository.findById(personnelMedicalId).orElseThrow(() -> new NotFoundException("Personnel Medical introuvable"));
        return personnelMedical.getConsultations();
    }

    public List<Hospitalisation> getHospitalisationsByPersonnelMedical(Long personnelMedicalId) {
        PersonnelMedical personnelMedical = (PersonnelMedical)this.personnelMedicalRepository.findById(personnelMedicalId).orElseThrow(() -> new NotFoundException("Personnel Medical introuvable"));
        return personnelMedical.getHospitalisations();
    }

    public List<Rdv> getRdvByPersonnelMedical(Long personnelMedicalId) {
        PersonnelMedical personnelMedical = (PersonnelMedical)this.personnelMedicalRepository.findById(personnelMedicalId).orElseThrow(() -> new NotFoundException("Personnel Medical introuvable"));
        return personnelMedical.getRdv();
    }

    public List<PersonnelMedical> getPersonnelMedicalByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.personnelMedicalRepository);
    }

    public void validerPersonnelMedical(@Valid PersonnelMedical personnelMedical) {
        this.personnelMedicalValidator.validate(personnelMedical, (Errors)new BeanPropertyBindingResult((Object)personnelMedical, "personnelMedical"));
    }
}

