/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Prescription;
import org.hopeclinic.gestiondespatients.repository.PrescriptionRepository;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class PrescriptionService {
    private final PrescriptionRepository prescriptionRepository;

    public PrescriptionService(PrescriptionRepository prescriptionRepository) {
        this.prescriptionRepository = prescriptionRepository;
    }

    public List<Prescription> getAllPrescriptions() {
        return this.prescriptionRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Prescription> getPrescriptionsByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.prescriptionRepository);
    }

    public Long count() {
        return this.prescriptionRepository.count();
    }

    public Prescription getPrescriptionById(Long id) {
        Optional prescriptionOptional = this.prescriptionRepository.findById(id);
        return prescriptionOptional.orElse(null);
    }

    public Prescription createPrescription(Prescription prescription) {
        return (Prescription)this.prescriptionRepository.save(prescription);
    }

    public Prescription updatePrescription(Long id, Prescription updatedPrescription) {
        Optional prescriptionOptional = this.prescriptionRepository.findById(id);
        if (prescriptionOptional.isPresent()) {
            Prescription prescription = (Prescription)prescriptionOptional.get();
            prescription.setDureeTraitement(updatedPrescription.getDureeTraitement());
            prescription.setNbPriseParJour(updatedPrescription.getNbPriseParJour());
            prescription.setDose(updatedPrescription.getDose());
            return (Prescription)this.prescriptionRepository.save(prescription);
        }
        return null;
    }

    public boolean deletePrescription(Long id) {
        Optional prescriptionOptional = this.prescriptionRepository.findById(id);
        if (prescriptionOptional.isPresent()) {
            this.prescriptionRepository.delete((Prescription)prescriptionOptional.get());
            return true;
        }
        return false;
    }
}

