/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Rdv;
import org.hopeclinic.gestiondespatients.repository.RdvRepository;
import org.hopeclinic.gestiondespatients.type.EtatOperation;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class RdvService {
    private final RdvRepository rdvRepository;

    public RdvService(RdvRepository rdvRepository) {
        this.rdvRepository = rdvRepository;
    }

    public List<Rdv> getAllRdv() {
        return this.rdvRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"date", "heure"}));
    }

    public List<Rdv> getRdvByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.rdvRepository);
    }

    public Long count() {
        return this.rdvRepository.count();
    }

    public long getTodayRdvCount() {
        Date today = new Date();
        return this.rdvRepository.countByDate(today);
    }

    public Rdv getRdvById(Long id) {
        Optional rdvOptional = this.rdvRepository.findById(id);
        return rdvOptional.orElse(null);
    }

    public Rdv createRdv(Rdv rdv) {
        return (Rdv)this.rdvRepository.save(rdv);
    }

    public Rdv updateRdv(Long id, Rdv updatedRdv) {
        Optional rdvOptional = this.rdvRepository.findById(id);
        if (rdvOptional.isPresent()) {
            Rdv rdv = (Rdv)rdvOptional.get();
            rdv.setDate(updatedRdv.getDate());
            rdv.setEtat(updatedRdv.getEtat());
            rdv.setSexe(updatedRdv.getSexe());
            rdv.setHeure(updatedRdv.getHeure());
            rdv.setPatient(updatedRdv.getPatient());
            rdv.setService(updatedRdv.getService());
            rdv.setPersonnelMedical(updatedRdv.getPersonnelMedical());
            return (Rdv)this.rdvRepository.save(rdv);
        }
        return null;
    }

    public boolean deleteRdv(Long id) {
        Optional rdvOptional = this.rdvRepository.findById(id);
        if (rdvOptional.isPresent()) {
            this.rdvRepository.delete((Rdv)rdvOptional.get());
            return true;
        }
        return false;
    }

    public void cancelExpiredRdv(Date currentTime) {
        List<Rdv> rdv = this.rdvRepository.findByEtatAndDateBefore(EtatOperation.EN_ATTENTE, currentTime);
        for (Rdv r : rdv) {
            r.setEtat(EtatOperation.ANNULEE);
            this.rdvRepository.save(r);
        }
    }
}

