/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Recu;
import org.hopeclinic.gestiondespatients.repository.RecuRepository;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class RecuService {
    private final RecuRepository recuRepository;

    public RecuService(RecuRepository recuRepository) {
        this.recuRepository = recuRepository;
    }

    public List<Recu> getAllRecus() {
        return this.recuRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Recu> getRecusByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.recuRepository);
    }

    public Long count() {
        return this.recuRepository.count();
    }

    public Recu getRecuById(Long id) {
        Optional recuOptional = this.recuRepository.findById(id);
        return recuOptional.orElse(null);
    }

    public Recu createRecu(Recu recu) {
        return (Recu)this.recuRepository.save(recu);
    }

    public Recu updateRecu(Long id, Recu updatedRecu) {
        Optional recuOptional = this.recuRepository.findById(id);
        if (recuOptional.isPresent()) {
            Recu recu = (Recu)recuOptional.get();
            recu.setMontant(updatedRecu.getMontant());
            recu.setDatePayment(updatedRecu.getDatePayment());
            return (Recu)this.recuRepository.save(recu);
        }
        return null;
    }

    public boolean deleteRecu(Long id) {
        Optional recuOptional = this.recuRepository.findById(id);
        if (recuOptional.isPresent()) {
            this.recuRepository.delete((Recu)recuOptional.get());
            return true;
        }
        return false;
    }
}

