/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Role;
import org.hopeclinic.gestiondespatients.repository.RoleRepository;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.stereotype.Service;

@Service
public class RoleService {
    private final RoleRepository roleRepository;

    public RoleService(RoleRepository roleRepository) {
        this.roleRepository = roleRepository;
    }

    public List<Role> getAllRoles() {
        return this.roleRepository.findAll();
    }

    public List<Role> getRolesByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.roleRepository);
    }

    public Long count() {
        return this.roleRepository.count();
    }

    public Role getRoleById(Long id) {
        Optional roleOptional = this.roleRepository.findById(id);
        return roleOptional.orElse(null);
    }

    public Role createRole(Role role) {
        return (Role)this.roleRepository.save(role);
    }

    public Role updateRole(Long id, Role updatedRole) {
        Optional roleOptional = this.roleRepository.findById(id);
        if (roleOptional.isPresent()) {
            Role role = (Role)roleOptional.get();
            role.setNom(updatedRole.getNom());
            return (Role)this.roleRepository.save(role);
        }
        return null;
    }

    public boolean deleteRole(Long id) {
        Optional roleOptional = this.roleRepository.findById(id);
        if (roleOptional.isPresent()) {
            this.roleRepository.delete((Role)roleOptional.get());
            return true;
        }
        return false;
    }
}

