/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Service;
import org.hopeclinic.gestiondespatients.repository.ServiceRepository;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;

@org.springframework.stereotype.Service
public class ServiceService {
    private final ServiceRepository serviceRepository;

    public ServiceService(ServiceRepository serviceRepository) {
        this.serviceRepository = serviceRepository;
    }

    public List<Service> getAllServices() {
        return this.serviceRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Service> getServicesByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.serviceRepository);
    }

    public Long count() {
        return this.serviceRepository.count();
    }

    public Service getServiceById(Long id) {
        Optional serviceOptional = this.serviceRepository.findById(id);
        return serviceOptional.orElse(null);
    }

    public Service createService(Service service) {
        return (Service)this.serviceRepository.save(service);
    }

    public Service updateService(Long id, Service updatedService) {
        Optional roleOptional = this.serviceRepository.findById(id);
        if (roleOptional.isPresent()) {
            Service service = (Service)roleOptional.get();
            service.setNom(updatedService.getNom());
            service.setDescription(updatedService.getDescription());
            service.setPrixConsultation(updatedService.getPrixConsultation());
            return (Service)this.serviceRepository.save(service);
        }
        return null;
    }

    public boolean deleteService(Long id) {
        Optional roleOptional = this.serviceRepository.findById(id);
        if (roleOptional.isPresent()) {
            this.serviceRepository.delete((Service)roleOptional.get());
            return true;
        }
        return false;
    }
}

