/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.hopeclinic.gestiondespatients.model.Acte;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Soin;
import org.hopeclinic.gestiondespatients.repository.SoinRepository;
import org.hopeclinic.gestiondespatients.service.ActeService;
import org.hopeclinic.gestiondespatients.service.FactureService;
import org.hopeclinic.gestiondespatients.type.EtatFacture;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class SoinService {
    private final SoinRepository soinRepository;
    private final FactureService factureService;
    private final ActeService acteService;

    public SoinService(SoinRepository soinRepository, FactureService factureService, ActeService acteService) {
        this.soinRepository = soinRepository;
        this.factureService = factureService;
        this.acteService = acteService;
    }

    public List<Soin> getAllSoins() {
        return this.soinRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Soin> getSoinsByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.soinRepository);
    }

    public Long count() {
        return this.soinRepository.count();
    }

    public Soin getSoinById(Long id) {
        Optional soinOptional = this.soinRepository.findById(id);
        return soinOptional.orElse(null);
    }

    public List<Soin> createSoins(List<Soin> newSoins) {
        ArrayList soins = new ArrayList();
        ArrayList<Acte> actes = new ArrayList<Acte>();
        Facture facture = new Facture(null, UUID.randomUUID().toString(), 0.0, false, 0, 0.0, 0.0, 0.0, EtatFacture.NON_PAYEE, null, null, null, null, null, null, null, null, null);
        newSoins.forEach(soin -> {
            soin.setFacture(facture);
            soins.add(soin);
            Acte acte = new Acte(null, soin.getObservation(), soin.getDateCreation(), null, soin.getPersonnelMedical(), soin.getFacture().getHospitalisation(), soin.getService());
            actes.add(acte);
        });
        this.acteService.createActes(actes);
        facture.setPatient(((Soin)soins.get(0)).getDossierMedical().getPatient());
        this.factureService.createFacture(facture);
        return this.soinRepository.saveAll(soins);
    }

    public Soin updateSoin(Long id, Soin updatedSoin) {
        Optional soinOptional = this.soinRepository.findById(id);
        if (soinOptional.isPresent()) {
            Soin soin = (Soin)soinOptional.get();
            soin.setObservation(updatedSoin.getObservation());
            soin.setPartPayee(updatedSoin.getPartPayee());
            soin.setTypeSoin(updatedSoin.getTypeSoin());
            soin.setService(updatedSoin.getService());
            soin.setPatient(updatedSoin.getPatient());
            soin.setFacture(updatedSoin.getFacture());
            return (Soin)this.soinRepository.save(soin);
        }
        return null;
    }

    public boolean deleteSoin(Long id) {
        Optional soinOptional = this.soinRepository.findById(id);
        if (soinOptional.isPresent()) {
            this.soinRepository.delete((Soin)soinOptional.get());
            return true;
        }
        return false;
    }
}

