/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Symptome;
import org.hopeclinic.gestiondespatients.repository.SymptomeRepository;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.stereotype.Service;

@Service
public class SymptomeService {
    private final SymptomeRepository symptomeRepository;

    public SymptomeService(SymptomeRepository symptomeRepository) {
        this.symptomeRepository = symptomeRepository;
    }

    public List<Symptome> getAllSymptomes() {
        return this.symptomeRepository.findAll();
    }

    public List<Symptome> getSymptomesByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.symptomeRepository);
    }

    public Long count() {
        return this.symptomeRepository.count();
    }

    public Symptome getSymptomeById(Long id) {
        Optional symptomeOptional = this.symptomeRepository.findById(id);
        return symptomeOptional.orElse(null);
    }

    public Symptome createSymptome(Symptome symptome) {
        return (Symptome)this.symptomeRepository.save(symptome);
    }

    public Symptome updateSymptome(Long id, Symptome updatedSymptome) {
        Optional symptomeOptional = this.symptomeRepository.findById(id);
        if (symptomeOptional.isPresent()) {
            Symptome symptome = (Symptome)symptomeOptional.get();
            symptome.setObservation(updatedSymptome.getObservation());
            return (Symptome)this.symptomeRepository.save(symptome);
        }
        return null;
    }

    public boolean deleteSymptome(Long id) {
        Optional symptomeOptional = this.symptomeRepository.findById(id);
        if (symptomeOptional.isPresent()) {
            this.symptomeRepository.delete((Symptome)symptomeOptional.get());
            return true;
        }
        return false;
    }
}

