/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.TypeExamen;
import org.hopeclinic.gestiondespatients.repository.TypeExamenRepository;
import org.springframework.stereotype.Service;

@Service
public class TypeExamenService {
    private final TypeExamenRepository typeExamenRepository;

    public TypeExamenService(TypeExamenRepository typeExamenRepository) {
        this.typeExamenRepository = typeExamenRepository;
    }

    public List<TypeExamen> getAllTypeExamens() {
        return this.typeExamenRepository.findAll();
    }

    public Long count() {
        return this.typeExamenRepository.count();
    }

    public TypeExamen getTypeExamenById(Long id) {
        Optional typeExamenOptional = this.typeExamenRepository.findById(id);
        return typeExamenOptional.orElse(null);
    }

    public List<TypeExamen> getByService(String service) {
        return this.typeExamenRepository.findByService(service);
    }

    public TypeExamen createTypeExamen(TypeExamen typeExamen) {
        return (TypeExamen)this.typeExamenRepository.save(typeExamen);
    }

    public TypeExamen updateTypeExamen(Long id, TypeExamen updatedTypeExamen) {
        Optional typeExamenOptional = this.typeExamenRepository.findById(id);
        if (typeExamenOptional.isPresent()) {
            TypeExamen typeExamen = (TypeExamen)typeExamenOptional.get();
            typeExamen.setNom(updatedTypeExamen.getNom());
            return (TypeExamen)this.typeExamenRepository.save(typeExamen);
        }
        return null;
    }

    public boolean deleteTypeExamen(Long id) {
        Optional typeExamenOptional = this.typeExamenRepository.findById(id);
        if (typeExamenOptional.isPresent()) {
            this.typeExamenRepository.delete((TypeExamen)typeExamenOptional.get());
            return true;
        }
        return false;
    }
}

