/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.utils;

import java.util.Calendar;
import java.util.Date;

public abstract class DateHelper {
    public static Date getStartOfDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public static Date getStartOfWeekend(Calendar calendar) {
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 7) {
            return DateHelper.getStartOfDay(calendar);
        }
        int daysUntilSaturday = (7 - dayOfWeek + 7) % 7;
        calendar.add(5, -daysUntilSaturday);
        return DateHelper.getStartOfDay(calendar);
    }

    public static Date getEndOfWeekend(Calendar calendar) {
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1) {
            return DateHelper.getEndOfDay(calendar);
        }
        int daysUntilSunday = (1 - dayOfWeek + 7) % 7;
        calendar.add(5, daysUntilSunday);
        return DateHelper.getEndOfDay(calendar);
    }

    public static Date getStartOfMonth(Calendar calendar) {
        calendar.set(5, 1);
        return DateHelper.getStartOfDay(calendar);
    }

    public static Date getEndOfMonth(Calendar calendar) {
        calendar.set(5, calendar.getActualMaximum(5));
        return DateHelper.getEndOfDay(calendar);
    }

    public static Date getStartOfYear(Calendar calendar) {
        calendar.set(2, 0);
        calendar.set(5, 1);
        return DateHelper.getStartOfDay(calendar);
    }

    public static Date getEndOfYear(Calendar calendar) {
        calendar.set(2, 11);
        calendar.set(5, 31);
        return DateHelper.getEndOfDay(calendar);
    }
}

