/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.hopeclinic.gestiondespatients.type.AntecedentType;
import org.hopeclinic.gestiondespatients.type.EtatFacture;
import org.hopeclinic.gestiondespatients.type.EtatOperation;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

public abstract class Utils {
    private static final Map<String, Class<? extends Enum<?>>> enumMappings = new HashMap();

    public static <T> List<T> getLastNItems(List<T> list, int n) {
        if (list.size() > n) {
            return list.subList(list.size() - n, list.size());
        }
        return list;
    }

    private static Enum<?> convertToEnum(String value, Class<? extends Enum<?>> enumType) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        for (Enum<?> enumValue : enumType.getEnumConstants()) {
            if (!enumValue.name().equals(value)) continue;
            return enumValue;
        }
        throw new IllegalArgumentException("Invalid value for enum " + enumType.getSimpleName() + ": " + value);
    }

    public static <T> List<T> getByFilters(Map<String, Object> filters, JpaSpecificationExecutor<T> executor) {
        Specification & Serializable spec = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            for (Map.Entry entry : filters.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                Class<? extends Enum<?>> enumType = enumMappings.get(key);
                if (key.contains(".")) {
                    String[] parts = key.split("\\.");
                    Join join = root.join(parts[0]);
                    predicates.add(criteriaBuilder.equal((Expression)join.get(parts[1]), value));
                    continue;
                }
                if (enumType != null) {
                    Enum<?> enumValue = Utils.convertToEnum((String)value, enumType);
                    predicates.add(criteriaBuilder.equal((Expression)root.get("etat"), enumValue));
                    continue;
                }
                predicates.add(criteriaBuilder.equal((Expression)root.get(key), value));
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[0]));
        };
        return executor.findAll((Specification)spec);
    }

    static {
        enumMappings.put("typeAntecedant", AntecedentType.class);
        enumMappings.put("etatFacture", EtatFacture.class);
        enumMappings.put("etatOperation", EtatOperation.class);
    }
}

